VERSION 1.0 CLASS
BEGIN
  MultiUse = -1  'True
  Persistable = 0  'NotPersistable
  DataBindingBehavior = 0  'vbNone
  DataSourceBehavior  = 0  'vbNone
  MTSTransactionMode  = 0  'NotAnMTSObject
END
Attribute VB_Name = "clsMCPHandler"
Attribute VB_GlobalNameSpace = False
Attribute VB_Creatable = True
Attribute VB_PredeclaredId = False
Attribute VB_Exposed = False
Option Explicit

Private Index      As Integer
Private Winsock    As Winsock

'Output methods
Public Event OutputPacketRecieved(ByVal Index As Integer, ByVal PacketID As String)
Public Event OutputPacketSent(ByVal Index As Integer, ByVal PacketID As String)

Public Function setClassVars(ByVal myIndex As Integer, ByRef myWinsock As Winsock)
    Index = myIndex
    Set Winsock = myWinsock
End Function

Public Function handleMCPPACKETSRAW(ByVal Data As String)
    Dim pktConstant     As Byte

    With PktBuffer
        .SetData Data
        .GetWORD
        pktConstant = .GetByte
    End With
    
    'Debug.Print DebugOutput(Data)
    
    Select Case pktConstant
        Case MCP_STARTUP
            RaiseEvent OutputPacketRecieved(Index, "MCP_STARTUP")
            Call handleMCP_STARTUP
            
        Case MCP_CHARLIST2
            RaiseEvent OutputPacketRecieved(Index, "MCP_CHARLIST2")
            Call handleMCP_CHARLIST2
            
        Case MCP_CHARCREATE
            RaiseEvent OutputPacketRecieved(Index, "MCP_CHARCREATE")
            Call handleMCP_CHARCREATE
            
        Case MCP_CHARDELETE
            RaiseEvent OutputPacketRecieved(Index, "MCP_CHARDELETE")
            Call handleMCP_CHARDELETE
            
        Case MCP_CHARLOGON
            RaiseEvent OutputPacketRecieved(Index, "MCP_CHARLOGON")
            Call handleMCP_CHARLOGON
            
        Case MCP_CHARUPGRADE
            RaiseEvent OutputPacketRecieved(Index, "MCP_CHARUPGRADE")
            Call handleMCP_CHARUPGRADE
            
    End Select
End Function


'Handling Packet Functions:

Private Function handleMCP_CHARUPGRADE()
    Select Case PktBuffer.GetDWORD
        Case &H0
            AddC Index, frmMain.rtbChat, True, COLORS.ID_COLOR_SUCCEED, hMCP & "Character upgrade successful"
        Case &H46
            AddC Index, frmMain.rtbChat, True, COLORS.ID_COLOR_FAILED, hMCP & "Character upgrade failed (Character not found)"
        Case &H7A
            AddC Index, frmMain.rtbChat, True, COLORS.ID_COLOR_FAILED, hMCP & "Character upgrade failed"
        Case &H7B
            AddC Index, frmMain.rtbChat, True, COLORS.ID_COLOR_FAILED, hMCP & "Character upgrade failed (Character expired)"
        Case &H7C
            AddC Index, frmMain.rtbChat, True, COLORS.ID_COLOR_FAILED, hMCP & "Character upgrade failed (Already expansion character)"
    End Select
End Function

Private Function handleMCP_CHARLOGON()
    Select Case PktBuffer.GetDWORD
        Case &H0
            AddC Index, frmMain.rtbChat, True, COLORS.ID_COLOR_SUCCEED, hMCP & "Character logon successful"
            Unload frmRealm
        Case &H46
            AddC Index, frmMain.rtbChat, True, COLORS.ID_COLOR_FAILED, hMCP & "Character logon failed (Character does not exist)"
        Case &H7A
            AddC Index, frmMain.rtbChat, True, COLORS.ID_COLOR_FAILED, hMCP & "Character logon failed"
        Case &H7B
            AddC Index, frmMain.rtbChat, True, COLORS.ID_COLOR_FAILED, hMCP & "Character logon failed (Expired character)"
    End Select
End Function

Private Function handleMCP_CHARDELETE()
    Select Case PktBuffer.GetDWORD
        Case &H0
            AddC Index, frmMain.rtbChat, True, COLORS.ID_COLOR_SUCCEED, hMCP & "Character deleted successfully"
            Unload frmRealm
            sendMCP_CHARLIST2
        Case &H49
            AddC Index, frmMain.rtbChat, True, COLORS.ID_COLOR_FAILED, hMCP & "Character does not existed"
    End Select
End Function

Private Function handleMCP_CHARCREATE()
    Select Case PktBuffer.GetDWORD
        Case &H0
            AddC Index, frmMain.rtbChat, True, COLORS.ID_COLOR_SUCCEED, hMCP & "Character created successfully"
            Unload frmRealm
            sendMCP_CHARLIST2
        Case &H14
            AddC Index, frmMain.rtbChat, True, COLORS.ID_COLOR_FAILED, hMCP & "Character creation failed (Already exists or max number reached)"
        Case &H15
            AddC Index, frmMain.rtbChat, True, COLORS.ID_COLOR_FAILED, hMCP & "Character creation failed (Invalid name)"
    End Select
End Function

Private Function handleMCP_CHARLIST2()
    Dim Expires         As Long
    Dim Characterlist   As Long
    Dim i               As Integer
    
    With PktBuffer
        .GetWORD
        Characterlist = .GetWORD
        .GetDWORD
        
        'Debug.Print "Requested characters: " & Characterlist
        
        frmRealm.Index = Index
        Set frmRealm.Winsock = Winsock
        
        For i = 1 To Characterlist
            Expires = .GetDWORD
            frmRealm.lvCharacters.ListItems.Add , , .GetString
            frmRealm.lvCharacters.ListItems(frmRealm.lvCharacters.ListItems.Count).ListSubItems.Add , , "0x" & Hex(.GetWORD)
            frmRealm.lvCharacters.ListItems(frmRealm.lvCharacters.ListItems.Count).ListSubItems.Add , , .GetString
            frmRealm.lvCharacters.ListItems(frmRealm.lvCharacters.ListItems.Count).ListSubItems.Add , , Expires
        Next i
        frmRealm.Show
    End With
End Function

Private Function handleMCP_STARTUP()
    Select Case PktBuffer.GetDWORD
        Case &H0
            AddC Index, frmMain.rtbChat, True, COLORS.ID_COLOR_SUCCEED, hMCP & "Realm logon successful"
            If (Bots(Index).Character <> vbNullString) Then
                sendMCP_CHARLOGON (Bots(Index).Character)
            End If
        Case &HC
            AddC Index, frmMain.rtbChat, True, COLORS.ID_COLOR_FAILED, hMCP & "No battle.net connection detected"
    End Select
End Function

'Send Packet Functions:
Public Function sendMCP_STARTUP()
    With PktBuffer
        .Reset
        .InsertNonNTString BNETDATA(Index).strMCPChunk1
        .InsertNonNTString BNETDATA(Index).strMCPChunk2
        .InsertNTString Bots(Index).RealUsername
        
        .Send Winsock, MCP_STARTUP, pMCP
    End With
    RaiseEvent OutputPacketSent(Index, "MCP_STARTUP")
End Function

Public Function sendMCP_CHARLIST2()
    With PktBuffer
        .Reset
        .InsertDWORD &H8
        
        .Send Winsock, MCP_CHARLIST2, pMCP
    End With
    RaiseEvent OutputPacketSent(Index, "MCP_CHARLIST2")
End Function

Public Function sendMCP_CHARCREATE(ByVal Class As Long, ByVal Flags As Integer, ByVal Name As String)
    With PktBuffer
        .Reset
        .InsertDWORD Class
        .InsertWORD Flags
        .InsertNTString Name
        
        .Send Winsock, MCP_CHARCREATE, pMCP
    End With
    RaiseEvent OutputPacketSent(Index, "MCP_CHARECREATE")
End Function

Public Function sendMCP_CHARDELETE(ByVal Name As String)
    With PktBuffer
        .Reset
        .InsertWORD &H0
        .InsertNTString Name
        
        .Send Winsock, MCP_CHARDELETE, pMCP
    End With
    RaiseEvent OutputPacketSent(Index, "MCP_CHARDELETE")
End Function

Public Function sendMCP_CHARLOGON(ByVal Name As String)
    With PktBuffer
        .Reset
        .InsertNTString Name
        
        .Send Winsock, MCP_CHARLOGON, pMCP
    End With
    RaiseEvent OutputPacketSent(Index, "MCP_CHARLOGON")
End Function

Public Function sendMCP_CHARUPGRADE(ByVal Name As String)
    With PktBuffer
        .Reset
        .InsertNTString Name
        
        .Send Winsock, MCP_CHARUPGRADE, pMCP
    End With
    RaiseEvent OutputPacketSent(Index, "MCP_CHARUPGRADE")
End Function
